MODULE GRAFTRAK
!...GLOBAL VARIABLE USED IN BOTH WHALTRAK AND GRAFTRAK ROUTINES
   USE IFQWIN
   IMPLICIT NONE
   INTEGER*2 NUMFONTS,FONTNUM,JTIME,I2
   INTEGER*2 IHR,IMIN,ISEC,I100TH, IYR, IMO, IDA, ICHECK
   INTEGER*4 I,J,K, MSEC, MMIN, JTIMEZERO, LASTTIME, IERR, ISEQ 
   REAL*8    CLICKTIME, LASTCLICKTIME, CLICKINTERVAL
   INTEGER*4 ISTAT,IDIR,NDETECT, NWHALES, IX1, IX2, IY1, IY2, IXMOUSE, IYMOUSE
   DOUBLE PRECISION LONG1,LONG2,LAT1,LAT2,SCALE,HPDIST
   DOUBLE PRECISION LONGXX(30000),LATXX(30000),TIMEXX(30000)
   DOUBLE PRECISION XLONGXX(10000),XLATXX(10000),XBEAR1(10000),XBEAR2(10000),XTIMEXX(10000)
   DOUBLE PRECISION WLONGXX(1000),WLATXX(1000), REDTIME, DEADTIME, DISTARAY
   DOUBLE PRECISION ICONSIZE,DOTSIZE,X1,X2,Y1,Y2,DIST,SIMDIST,SIMHEAD,RLAT,RLONG
   DOUBLE PRECISION PREVLAT,PREVLONG,LASTLAT,LASTLONG,HEADING, OLDHEADING, SPEED
   DOUBLE PRECISION BEARING, WHALBEAR
   CHARACTER ALAT*12, ALONG*12, NORS*1, EORW*1, AHEAD*5, AOPERATOR*5, ABEAR*5
   CHARACTER AFILE*12, AFILEBAK*12, AFILELOG*12
   CHARACTER CURSOR_LAT*12, CURSOR_LONG*12, CURSOR_BEAR*5, CURSOR_DIST*6
   CHARACTER HPHONE_DIST*5, ADEADTIME*5, ASPEED*5, CLICK_INTERVAL*5, ACOMMENT*120
   LOGICAL STATUS, LCLICK, RCLICK, EFFORT,REPLAY,TURNING,INPUT_PENDING
   TYPE (qwinfo) winfo2
   CONTAINS
!
!...RE-DRAW PLOT SPACE AFTER NEW POSITION OR OTHER INPUT
   SUBROUTINE REDRAW()
   USE MSFLIB
   TYPE(XYCOORD) xy
   TYPE (wxycoord) WXY
   TYPE (rccoord) rc  
   INTEGER*4 ILATD, ILONGD, IS, IT, I, ICOLR, NUMFONTS
   REAL*8 RLATM, RLONGM, RADIUS

   NUMFONTS = INITIALIZEFONTS ( )
!
!...SET NEW WINDOW AREA CENTERED ON CURRENT LOCATION
      LAT1= LASTLAT +  SCALE
      LAT2= LASTLAT - SCALE
      LONG1= LASTLONG - SCALE*(800.0/600.0)/COSD(LASTLAT)
      LONG2= LASTLONG + SCALE*(800.0/600.0)/COSD(LASTLAT)
      STATUS= SETWINDOW(.TRUE.,LONG1,LAT1,LONG2,LAT2)
      CALL CLEARSCREEN($GCLEARSCREEN)
!
!...DRAW SCALE ICONS AT UPPER LEFT CORNER
      IX1= 0
      IX2= 20
      IY1= 0
      IY2= 20
      ISTAT= SETCOLOR(5)
      ISTAT= RECTANGLE($GFILLINTERIOR,IX1,IY1,IX2,IY2)
      IDIR= 1
      ISTAT= SETCOLOR(15)
      CALL TRIANGLE(IX1,IY1,IX2,IY2,IDIR)
      
      IY1= 20
      IY2= 40
      ISTAT= SETCOLOR(5)
      ISTAT= RECTANGLE($GFILLINTERIOR,IX1,IY1,IX2,IY2)
      IDIR= 3
      ISTAT= SETCOLOR(15)
      CALL TRIANGLE(IX1,IY1,IX2,IY2,IDIR)
!
!...DRAW CHECK BOXES ALONG LEFT SIDE
      ISTAT= SETCOLOR(5)
      DO I=1,10
         IX1= 0
         IX2= 20
         IY1= 30+I*30
         IY2= 60+I*30
         ISTAT= RECTANGLE($GBORDER,IX1,IY1,IX2,IY2)
      ENDDO
!
!...PRINT "TURNING" STATUS
      ISTAT = SETFONT('t''Arial''h20p')
      CALL MOVETO(25,70,XY)
      IF (TURNING) THEN
         CALL OUTGTEXT('TURNING')
      ELSE
         CALL OUTGTEXT('TURN   ')
      ENDIF
!
!...PRINT HYDROPHONE SPACING STATUS
      CALL MOVETO(25,100,XY)
      CALL OUTGTEXT('HYDROPHONE DIST (M):  ')
      CALL OUTGTEXT(HPHONE_DIST)
!
!...PRINT COMMENT STATUS
      CALL MOVETO(25,130,XY)
      CALL OUTGTEXT('COMMENT:  ')
!
!...PRINT OPERATOR STATUS
      CALL MOVETO(25,160,XY)
      CALL OUTGTEXT('OPERATOR: ')
      CALL OUTGTEXT(AOPERATOR)
!
!...PRINT EFFORT STATUS
      CALL MOVETO(25,190,XY)
      IF (EFFORT) THEN
         CALL OUTGTEXT('EFFORT: ON')
!         CALL MOVETO(750,10,XY)                    !DISPLAY 'ON' IN BIG LETTERS
!         ISTAT = SETFONT('t''Arial''h90p')
!         CALL OUTGTEXT('ON')
      ELSE
         CALL OUTGTEXT('EFFORT: OFF')
!         CALL MOVETO(750,10,XY)                    !DISPLAY 'OFF' IN BIG LETTERS
!         ISTAT = SETFONT('t''Arial''h90p')
!         CALL OUTGTEXT('OFF')
      ENDIF
      ISTAT = SETFONT('t''Arial''h20p')
!
!...PRINT BEARING ANGLE STATUS
      CALL MOVETO(25,220,XY)
      CALL OUTGTEXT('INPUT BEARING : ')
!
!...CLICK INTERVAL
      CALL MOVETO(25,250,XY)
      CALL OUTGTEXT('CLICK TIMER')
      IF ((CLICKINTERVAL.GT.0).AND.(CLICKINTERVAL.LE.999)) THEN
         CALL OUTGTEXT(CLICK_INTERVAL)
         CALL OUTGTEXT(' sec')
      ENDIF
!
!...ERASE OLD LINES
      CALL MOVETO(25,280,XY)
      CALL OUTGTEXT('ERASE LINES AFTER')
      WRITE (ADEADTIME,'(F5.0)',IOSTAT=IERR) DEADTIME
      CALL OUTGTEXT(ADEADTIME)
      CALL OUTGTEXT('min')
!
!...START OR END A RECORDING
      CALL MOVETO(25,310,XY)
      CALL OUTGTEXT('START/END RECORDING')
!
!...TIMED UPDATES (EG. 5-MIN UPDATES)
      CALL MOVETO(25,340,XY)
      CALL OUTGTEXT('TIMED UPDATES')
!
!...WRITE CURRENT LATITUDE AND LONGITUDE AND HEADING AT TOP OF SCREEN
      IF (LASTLAT .GT. 0) THEN
         NORS= 'N'
         ILATD= INT(LASTLAT)
         RLATM= (LASTLAT - ILATD) * 60.0
      ELSE
         NORS= 'S'
         ILATD= INT(-LASTLAT)
         RLATM= -(LASTLAT + ILATD) * 60.0
      ENDIF
      IF (LASTLONG .GT. 0) THEN
         EORW= 'E'
         ILONGD= INT(LASTLONG)
         RLONGM= (LASTLONG - ILONGD) * 60.0
      ELSE
         EORW= 'W'
         ILONGD= INT(-LASTLONG)
         RLONGM= -(LASTLONG + ILONGD) * 60.0
      ENDIF
      WRITE (ALAT, '(I5,1H:,F5.2,A1)') ILATD,RLATM,NORS
      WRITE (ALONG,'(I5,1H:,F5.2,A1)') ILONGD,RLONGM,EORW
!...WRITE CURRENT SHIP LOCATION AT TOP OF SCREEN
      ISTAT = SETFONT('t''Arial''h16w8')
      CALL MOVETO(25,1,XY)
      CALL OUTGTEXT('CURRENT LOCATION ')
      CALL OUTGTEXT(ALAT)
      CALL OUTGTEXT(ALONG)
      WRITE (AHEAD,'(F5.0)') HEADING
      CALL OUTGTEXT('  HEADING= ')
      CALL OUTGTEXT(AHEAD)
      WRITE (ASPEED,'(F5.1)') SPEED
      CALL OUTGTEXT('  SPEED= ')
      CALL OUTGTEXT(ASPEED)
!
!...WRITE LAST CURSOR LOCATION AT TOP OF SCREEN
      ISTAT = SETFONT('t''Arial''h16w8')
      CALL MOVETO(25,20,XY)
      CALL OUTGTEXT('  CURSOR LOCATION ')
      CALL OUTGTEXT(CURSOR_LAT)
      CALL OUTGTEXT(CURSOR_LONG)
      CALL OUTGTEXT('  BEARING= ')
      CALL OUTGTEXT(CURSOR_BEAR)
      CALL OUTGTEXT('   DIST= ')
      CALL OUTGTEXT(CURSOR_DIST)
!
!...DRAW SOLID SHIP SYMBOL AT CENTER OF WINDOW COORDINATE SYSTEM
      ISTAT= SETCOLOR(9)                      !BLUE
      ISTAT= ELLIPSE_W($GFILLINTERIOR,                  &
        (LASTLONG-DOTSIZE),(LASTLAT+DOTSIZE),     &
        (LASTLONG+DOTSIZE),(LASTLAT-DOTSIZE))
!
!...DRAW LINE TO INDICATE DIRECTION OF SHIP TRAVEL
      DIST= 1.0
      LAT1= LASTLAT
      LONG1= LASTLONG
      CALL MOVETO_W(LONG1,LAT1,WXY)
      CALL GREATCIRCLE(LAT1,LONG1,LAT2,LONG2,HEADING,DIST)
      ISTAT= LINETO_W(LONG2,LAT2)
!
!...DRAW UNFILLED SHIP SYMBOL AT PREVIOUS POSITIONS IN WINDOW COORDINATE SYSTEM
      ISTAT= SETCOLOR(9)
	   DO 10 IT= (JTIME-1),1,-1
         ISTAT= ELLIPSE_W($GBORDER,                     &
              (LONGXX(IT)-DOTSIZE),(LATXX(IT)+DOTSIZE),     &
              (LONGXX(IT)+DOTSIZE),(LATXX(IT)-DOTSIZE))
 10   CONTINUE
!
!...DRAW SOLID SYMBOLS AT LOCATIONS OF IDENTIFIED WHALE DETECTIONS
      ISTAT= SETCOLOR(12)
      IF (NWHALES .GT. 0) THEN
         DO 11 IT= 1,NWHALES
            ISTAT= ELLIPSE_W($GFILLINTERIOR,              &
              (WLONGXX(IT)-DOTSIZE),(WLATXX(IT)+DOTSIZE),     &
              (WLONGXX(IT)+DOTSIZE),(WLATXX(IT)-DOTSIZE))
 11      CONTINUE
      ENDIF
!                                           LL
!...DRAW FIVE CIRCLES OF 1 NMI RADIUS AT CENTER OF WINDOW COORDINATE SYSTEM
      ISTAT= SETCOLOR(5)
      DO 15 I=1,5
	      RADIUS= FLOAT(I)/60.0
         ISTAT= ELLIPSE_W($GBORDER,                                    &
           (LONGXX(JTIME)-RADIUS/COSD(LATXX(JTIME))),(LATXX(JTIME)+RADIUS),  &
           (LONGXX(JTIME)+RADIUS/COSD(LATXX(JTIME))),(LATXX(JTIME)-RADIUS))
 15   CONTINUE
!
!...DRAW RED LINES REPRESENTING BEARINGS TO PAST DETECTIONS, (IN YELLOW IF OLD)
	   DO 20 IS= 1,NDETECT
         IF (( ((IHR*60 + IMIN)- XTIMEXX(IS)) .GT. DEADTIME) .AND. (.NOT. REPLAY)) THEN
            ICOLR= 14                       !DO NOT PLOT LINES
         ELSE IF (( ((IHR*60 + IMIN)- XTIMEXX(IS)) .GT. REDTIME) .AND. (.NOT. REPLAY)) THEN
            ICOLR= 14                       !YELLOW
            CALL DRAWLINES(IS,ICOLR)
         ELSE
            ICOLR= 12                       !RED
            CALL DRAWLINES(IS,ICOLR)
         ENDIF
 20   CONTINUE

	RETURN
	END SUBROUTINE


!...THIS SUBROUTINE DRAWS 10NMI BEARING LINES FROM DETECTION LOCATIONS
   SUBROUTINE DRAWLINES(IS,ICOLR)
   USE MSFLIB
   INTEGER*4 ICOLR, IS
	TYPE (wxycoord) XY
      ISTAT= SETCOLOR(ICOLR)
      DIST= 10.0
      LAT1= XLATXX(IS)
      LONG1= XLONGXX(IS)
      CALL MOVETO_W(LONG1,LAT1,XY)
      CALL GREATCIRCLE(LAT1,LONG1,LAT2,LONG2,XBEAR1(IS),DIST)
      ISTAT= LINETO_W(LONG2,LAT2)
!
      LAT1= XLATXX(IS)
      LONG1= XLONGXX(IS)
      CALL MOVETO_W(LONG1,LAT1,XY)
      CALL GREATCIRCLE(LAT1,LONG1,LAT2,LONG2,XBEAR2(IS),DIST)
      ISTAT= LINETO_W(LONG2,LAT2)
!      WRITE (0,'(4F10.4)') LAT1,LONG1,LAT2,LONG2
   RETURN
   END SUBROUTINE


!-----------------------------------------------------------------------
! This routine takes bounding box coordinates and draws a triangle
! inside the box.  The direction of the triangle is determined by
! the shape variable IDIR.

      SUBROUTINE TRIANGLE_W(x1, y1, x2, y2, IDIR)

      USE MSFLIB

      DOUBLE PRECISION    x1, y1, x2, y2
      DOUBLE PRECISION    v1x, v1y, v2x, v2y, v3x, v3y, xmid, ymid
	   INTEGER*4 IDIR
      TYPE(WXYCOORD)  wxy

      xmid = x1 + (x2 - x1) / 2.0
      ymid = y1 + (y2 - y1) / 2.0

      select case (IDIR)
       case (1)
       v1x = x1 ; v1y = y2 ; v2x = x2 ; v2y = y2 ; v3x = xmid ; v3y = y1
       case (2)
       v1x = x2 ; v1y = y2 ; v2x = x2 ; v2y = y1 ; v3x = x1 ; v3y = ymid
       case (3)
       v1x = x2 ; v1y = y1 ; v2x = x1 ; v2y = y1 ; v3x = xmid ; v3y = y2
       case (4)
       v1x = x1 ; v1y = y1 ; v2x = x1 ; v2y = y2 ; v3x = x2 ; v3y = ymid
      end select

      call moveto_w(v1x, v1y, wxy)
      i2 = lineto_w(v2x, v2y)
      i2 = lineto_w(v3x, v3y)
      i2 = lineto_w(v1x, v1y)

      return
      ENDSUBROUTINE 


!-----------------------------------------------------------------------
! This routine takes bounding box coordinates and draws a triangle
! inside the box.  The direction of the triangle is determined by
! the shape variable IDIR.

      SUBROUTINE TRIANGLE(x1, y1, x2, y2, IDIR)

      USE MSFLIB

      INTEGER*4     x1, y1, x2, y2
      INTEGER*2     v1x, v1y, v2x, v2y, v3x, v3y, xmid, ymid
	   INTEGER*4 IDIR
      TYPE(XYCOORD)  xy
  

      xmid = x1 + (x2 - x1) / 2.0
      ymid = y1 + (y2 - y1) / 2.0

      select case (IDIR)
       case (1)
       v1x = x1 ; v1y = y2 ; v2x = x2 ; v2y = y2 ; v3x = xmid ; v3y = y1
       case (2)
       v1x = x2 ; v1y = y2 ; v2x = x2 ; v2y = y1 ; v3x = x1 ; v3y = ymid
       case (3)
       v1x = x2 ; v1y = y1 ; v2x = x1 ; v2y = y1 ; v3x = xmid ; v3y = y2
       case (4)
       v1x = x1 ; v1y = y1 ; v2x = x1 ; v2y = y2 ; v3x = x2 ; v3y = ymid
      end select

      call moveto(v1x, v1y, xy)
      i2 = lineto(v2x, v2y)
      i2 = lineto(v3x, v3y)
      i2 = lineto(v1x, v1y)

      return
      ENDSUBROUTINE 

   SUBROUTINE GETREPLAY()
   CHARACTER ALINE*80, BLINE*80, INFILE*40
   REAL*8 RBEAR, DELTATIME
   INTEGER*4 ILINE,ENDTIME,NOWTIME,JHR,JMIN,JSEC,IBACK
   LOGICAL QUIT
   ILINE= 0
   IF (JTIME .EQ. 1) THEN
      QUIT= .FALSE.
      OPEN (20,FILE='USER',TITLE='Get REPLAY file specifications')
      WRITE (20,*) ' INPUT NAME OF TRAK FILE TO BE PLAYED BACK: '
      READ (20,'(A40)',IOSTAT=IERR) INFILE
      OPEN (UNIT= 14, FILE=INFILE, STATUS='OLD')
      WRITE (20,*) ' INPUT TIME OF LAST RECORD TO BE DISPLAYED (hhmm):'
      READ (20,'(I4)') ENDTIME
      IF (ENDTIME .EQ. 0) ENDTIME= -1
      CLOSE (20)
   ENDIF
   JTIME= 0
   DO WHILE (.NOT. QUIT)
      READ (14,'(A80)',END=99) ALINE
      ILINE= ILINE + 1
!      WRITE (0,'(A8,I5,A50)') 'LINE# =',ILINE,ALINE(1:50)
      READ (ALINE(6:9),'(I4)') NOWTIME
      IF (NOWTIME .EQ. ENDTIME) QUIT= .TRUE.
      IF ((LASTLAT .EQ. 0.0).AND.(LASTLONG .EQ. 0.0)) THEN
            READ (ALINE(21:28),'(F8.4)') LASTLAT
            READ (ALINE(29:38),'(F9.4)') LASTLONG
      ENDIF
      IF ((ALINE(4:4) .EQ. '*').OR.(ALINE(4:4) .EQ. 'T')) THEN
         READ (ALINE(6:7),'(I2)') IHR
         READ (ALINE(8:9),'(I2)') IMIN
         READ (ALINE(10:11),'(I2)') ISEC
         DELTATIME= (IHR - JHR) + (IMIN - JMIN)/60.0 + (ISEC - JSEC)/3600.0
         IF (DELTATIME .LT. -23.0) DELTATIME= DELTATIME + 24.0
!...RECORD POSITION AND CALCULATE HEADING IF AT LEAST 5 MINUTES HAVE PASSED
         IF (DELTATIME .GE. 0.05) THEN
            READ (ALINE(21:28),'(F8.4)') RLAT
            READ (ALINE(29:38),'(F9.4)') RLONG
            IF (((RLAT .NE. LASTLAT).OR.(RLONG .NE. LASTLONG)).AND.   &
                ((RLAT .NE. 0.0).AND.(RLONG .NE. 0.0))) THEN
               JTIME= JTIME + 1
               LATXX(JTIME)= RLAT
               LONGXX(JTIME)= RLONG
               HEADING= -1.0
               CALL GREATCIRCLE(LASTLAT,LASTLONG,LATXX(JTIME),LONGXX(JTIME),HEADING,DIST)
                  WRITE (0,'(6F10.3)') LASTLAT,LASTLONG,LATXX(JTIME),LONGXX(JTIME),HEADING,DIST
               SPEED= DIST / DELTATIME
               JHR= IHR
               JMIN= IMIN
               JSEC= ISEC
               LASTLAT= LATXX(JTIME)
               LASTLONG= LONGXX(JTIME)
            ENDIF
         ENDIF
      ELSE IF (ALINE(4:4) .EQ. 'D') THEN
         NDETECT= NDETECT + 1
         READ (ALINE(21:28),'(F8.4)') XLATXX(NDETECT)
         READ (ALINE(29:38),'(F9.4)') XLONGXX(NDETECT)
         IF ((XLATXX(NDETECT) .EQ. 0.0).AND.(XLONGXX(NDETECT) .EQ. 0.0)) THEN
            READ (ALINE(6:7),'(I2)') IHR
            READ (ALINE(8:9),'(I2)') IMIN
            READ (ALINE(10:11),'(I2)') ISEC
            DELTATIME= (IHR - JHR) + (IMIN - JMIN)/60.0 + (ISEC - JSEC)/3600.0
            IF (DELTATIME .LT. -23.0) DELTATIME= DELTATIME + 24.0
            IF (DELTATIME .LT. 0.0) THEN
               WRITE (0,*) ' WARNING:  TIME IS OUT OF CHRONOLOGICAL ORDER'
               PAUSE
            ENDIF
!...read ahead until valid lat/long are found from which to compute new heading
            IBACK= 0
            RLAT= 0.0
            RLONG= 0.0
            DO WHILE ((RLAT .EQ. 0.0).AND.(RLONG .EQ. 0.0))
               READ (14,'(A80)',END=99) BLINE
                 WRITE (0,'(A80)') BLINE
               IBACK= IBACK + 1
               READ (BLINE(21:28),'(F8.4)') RLAT
               READ (BLINE(29:38),'(F9.4)') RLONG
               IF ((RLAT .EQ. LASTLAT).AND.(RLONG .EQ. LASTLONG)) THEN
                  RLAT= 0.0
                  RLONG= 0.0
               ENDIF
            END DO
            HEADING= -1.0
            CALL GREATCIRCLE(LASTLAT,LASTLONG,RLAT,RLONG,HEADING,DIST)
!...backspace to previous point in data file
            DO I= 1,IBACK
               BACKSPACE 14
            END DO
!...interpolate to find new location
            DIST= SPEED * DELTATIME
            CALL GREATCIRCLE(LASTLAT,LASTLONG,XLATXX(NDETECT),XLONGXX(NDETECT),HEADING,DIST)
               WRITE (0,'(6F10.3)') LASTLAT,LASTLONG,XLATXX(NDETECT),XLONGXX(NDETECT),HEADING,DIST
         ENDIF
         READ (ALINE(40:44),'(F5.1)') RBEAR
         XBEAR1(NDETECT)= HEADING + RBEAR
         XBEAR2(NDETECT)= HEADING - RBEAR
         IF (XBEAR1(NDETECT) .GT. 360) XBEAR1(NDETECT)= XBEAR1(NDETECT) - 360.
         IF (XBEAR2(NDETECT) .LT.   0) XBEAR2(NDETECT)= XBEAR2(NDETECT) + 360.
      ENDIF
   END DO
99 CONTINUE
   RLAT= LATXX(JTIME)
   RLONG= LONGXX(JTIME)
   RETURN                                                        
   END SUBROUTINE

   SUBROUTINE GETAKEY()
   USE MSFLIB
   CHARACTER*1 KEY1,KEY2
   CHARACTER*4 STR
   TYPE (rccoord)  rc
   CALL SETTEXTPOSITION (INT2(6), INT2(1), rc)
      KEY1 = GETCHARQQ()
      WRITE (STR,'(I3)') ICHAR(KEY1)
      CALL OUTTEXT(STR)
   IF(ICHAR(KEY1) .EQ. 0) THEN
      KEY2 = GETCHARQQ()
      WRITE (STR,'(I3)') ICHAR(KEY2)
      CALL OUTTEXT(STR)
   ELSE
      CALL OUTTEXT("    ")
   ENDIF
   IF (ICHAR(KEY1) .EQ. 0) THEN                    !INTERPRET FUNCTION KEY
      IF (ICHAR(KEY2) .EQ. 59) THEN                !F1: INCREASE SCALE
            SCALE= SCALE * 2.0
            ICONSIZE= ICONSIZE * 2.0
      ELSE IF (ICHAR(KEY2) .EQ. 60) THEN           !F2: DECREASE SCALE
            SCALE= SCALE / 2.0
            ICONSIZE= ICONSIZE / 2.0
      ENDIF
   ELSE IF ((ICHAR(KEY1) .EQ. 81).OR.(ICHAR(KEY1) .EQ. 113)) THEN    !q OR Q:  QUIT
      STOP
   ENDIF 
   RETURN
   END SUBROUTINE

!_______________________________________________________________________________
!...THIS SUBROUTINE OUTPUTS A CHARACTER STRING ALONG WITH A TIME/DATE STAMP AND
!...THE MOST RECENT POSITION TO FILE WITH LUN LOGICAL UNIT NUMBER
   SUBROUTINE DATAOUT(LUN,ACODE,ASTRING)
   CHARACTER ACODE*1, ASTRING*120, APERIOD*1
   CHARACTER  AYEAR*2, AMONTH*2, ADAY*2, AHR*2, AMIN*2, ASEC*2
   INTEGER*2 IMONTH,IDAY,IYEAR,LEN_STR,LUN
   ISEQ= ISEQ + 1
   IF (ISEQ .EQ. 1000) ISEQ= 0
!...GET CURRENT DATE/TIME
   CALL GETDAT(IYEAR,IMONTH,IDAY)
   IYEAR= IYEAR - 1900 
   IF (IYEAR .GE. 100) IYEAR= IYEAR - 100
   CALL GETTIM(IHR,IMIN,ISEC,I100TH)
!...CONVERT YEAR TO ZERO-FILLED CHARACTER STRING
   WRITE (AYEAR,'(I2)') IYEAR
   IF (AYEAR(1:1) .EQ. ' ') AYEAR(1:1)= '0'
!...CONVERT MONTH TO ZERO-FILLED CHARACTER STRING
   WRITE (AMONTH,'(I2)') IMONTH
   IF (AMONTH(1:1) .EQ. ' ') AMONTH(1:1)= '0'
!...CONVERT DAY TO ZERO-FILLED CHARACTER STRING
   WRITE (ADAY,'(I2)') IDAY
   IF (ADAY(1:1) .EQ. ' ') ADAY(1:1)= '0'
!...CONVERT HOUR TO ZERO-FILLED CHARACTER STRING
   WRITE (AHR,'(I2)') IHR
   IF (AHR(1:1) .EQ. ' ') AHR(1:1)= '0'
!...CONVERT MINUTE TO ZERO-FILLED CHARACTER STRING
   WRITE (AMIN,'(I2)') IMIN
   IF (AMIN(1:1) .EQ. ' ') AMIN(1:1)= '0'
!...CONVERT SECOND TO ZERO-FILLED CHARACTER STRING
   WRITE (ASEC,'(I2)') ISEC
   IF (ASEC(1:1) .EQ. ' ') ASEC(1:1)= '0'
!...INDICATE IF ON-EFFORT WITH A PERIOD IN COLUMN FOUR
   IF (EFFORT) THEN
      APERIOD= '.'
   ELSE
      APERIOD= ' '
   ENDIF
!...OPEN FILE, WRITE DATA, AND CLOSE IMMEDIATELY (TO SAVE IN CASE OF PROGRAM CRASH)
   LEN_STR= LEN_TRIM(ASTRING)
   IF (LUN .EQ. 13) THEN
      OPEN (13,FILE=AFILE,STATUS='OLD',POSITION='APPEND')
      WRITE (13,100) ISEQ,ACODE,APERIOD,AHR,AMIN,ASEC,AMONTH,ADAY,AYEAR,LASTLAT,LASTLONG,ASTRING(1:LEN_STR)
      CLOSE (13)
!...WRITE IDENTICAL DATA TO A BACKUP FILE (NOT OPEN AT SAME TIME AS MAIN DATA FILE)
      OPEN (14,FILE=AFILEBAK,STATUS='OLD',POSITION='APPEND')
      WRITE (14,100) ISEQ,ACODE,APERIOD,AHR,AMIN,ASEC,AMONTH,ADAY,AYEAR,LASTLAT,LASTLONG,ASTRING(1:LEN_STR)
      CLOSE (14)
   ELSE IF (LUN .EQ. 15) THEN
      OPEN (15,FILE=AFILELOG,STATUS='OLD',POSITION='APPEND')
      WRITE (15,100) ISEQ,ACODE,APERIOD,AHR,AMIN,ASEC,AMONTH,ADAY,AYEAR,LASTLAT,LASTLONG,ASTRING(1:LEN_STR)
      CLOSE (15)
   ENDIF
   ASTRING= ''
100 FORMAT(I3,2A1,3A2,1X,3A2,1X,F9.4,F10.4,1X,A)
   RETURN
   END SUBROUTINE

END MODULE GRAFTRAK

